<?php

namespace App\Models;
use App\Interfaces\IAffilie as IAffilie;
use Illuminate\Database\Eloquent\Model;
use Origine;
use App\Models\AyantDroit;
use DB;
class Affilier extends Model implements IAffilie
{

	  protected $table = 'affiliers';
    protected $fillable = ['Code', 'Nom', 'Prenom', 'Origine', 'CotisationM', 'SoinsAmbilatoire', 'PlafondChambre', 'PCNuit', 'UniteMaternite', 'ElseUniteMaternite', 'Pharmacie', 'Annee', 'Etat', 'PieceIndentite', 'Telephone', 'DateEntree', 'DateNaiss', 'Adresse', 'Medicament', 'Lunette', 'dents', 'labo', 'kinesie', 'reanimation', 'imagerie', 'Hospitalisation'];
    //protected $dates = ['DateEntree'];

     //ON RECUPERE TOUTES LES DONNEES DES AFFILIES

    public function fetchtAll(){

   

       if(session()->get('Profil') == 'Partenaire')
       { 
             return	$results =DB::table('affilier_partenaires')
                 ->join('affiliers', 'affilier_partenaires.Affilier', '=', 'affiliers.id')
                 ->join('origines', 'origines.id', '=', 'affiliers.Origine')
                ->select(DB::raw('affiliers.id,affiliers.Code, affiliers.Nom,affiliers.Prenom,affiliers.Origine,affiliers.DateEntree,affiliers.SoinsAmbilatoire,affiliers.PlafondChambre,affiliers.PCNuit,affiliers.UniteMaternite,affiliers.ElseUniteMaternite,affiliers.Pharmacie,affilier_partenaires.Partenaire,affiliers.DateNaiss, origines.Origine,affilier_partenaires.Partenaire'))
                ->wherePartenaire(session()->get('id'))
                ->where('affiliers.Etat',0)
                ->where('affilier_partenaires.Etat',0)
                ->groupBy('affiliers.id')
                ->limit(100)
                ->get();     
                
        }else{

        	 return	$results =DB::table('affiliers')
                ->Leftjoin('affilier_partenaires','affilier_partenaires.Affilier' , '=', 'affiliers.id')
                ->join('origines', 'origines.id', '=', 'affiliers.Origine')
                ->select(DB::raw('affiliers.id,affiliers.Code, affiliers.Nom,affiliers.Prenom,affiliers.Origine,affiliers.DateEntree,affiliers.SoinsAmbilatoire,affiliers.PlafondChambre,affiliers.PCNuit,affiliers.UniteMaternite,affiliers.ElseUniteMaternite,affiliers.Pharmacie,affilier_partenaires.Partenaire,affiliers.DateNaiss, origines.Origine,affilier_partenaires.Partenaire'))
                ->where('affiliers.Etat',0)
                ->groupBy('affiliers.id')
                ->orderBy("affiliers.id", "DESC")->take(10)
                ->get();     
        }
    }

    public  function saveData($request, $id){
      
      //ON CREER UN NOUVEAU OBJECT
      if (is_null($id)) {
      	  
      	
          $CurrentYear = date('Y');
        //Verification de L'unicite du code
         
        $NbreCode = $this::whereCode($request->Code)->where('Etat', '!=', 2)->count();
        $NbrePiece = $this::wherePieceindentite($request->Piece)->count();
        //$NbreTelephone = Affilier::whereTelephone($request->Telephone)->where('Telephone', '!=', '')->count();
        
    if ($NbreCode == 0) 
    {  
       // if ($NbreTelephone == 0) 
       // {
            if ($NbrePiece == 0) 
            {
            $this::create([
            'Code' => $request->Code,
            'Nom' => $request->Nom,
            'Prenom' => $request->Prenom,
            'Origine' => $request->Origine,
            'DateEntree' => $request->DateEntree,
            'CotisationM' => $request->Cotisation,
            'SoinsAmbilatoire' => $request->SA,
            'PlafondChambre' => $request->HPC,
            'PCNuit' => $request->HPCN,
            'UniteMaternite' => $request->Maternite,
            'ElseUniteMaternite' => $request->MaterniteP,
            'Pharmacie' => $request->Pharmacie,
            'Annee' => $CurrentYear,
            'PieceIndentite' => $request->Piece,
            'Telephone' => $request->Telephone,
            'DateNaiss' => $request->DateNaiss,
            'Lunette' => $request->Lunette,
            'dents' => $request->dents,
            'Hospitalisation'=>$request->Hospitalisation,
            'imagerie'=>$request->Imagerie,
            'reanimation'=>$request->Reanimation,
            'kinesie'=>$request->Kinesitherapie,
            'labo'=>$request->Laboratoire,
            'Adresse' => $request->Adresse,
            'Medicament' => $request->Medicament
        ]);
        
        $MaxId = $this::all()->max('id');

           AyantDroit::create([
            'Affilier' =>$MaxId,
            'Nom' => $request->Nom,
            'Prenom' => $request->Prenom,
            'Lien' => 'Lui meme'
        ]);

            session()->flash('message', 'Affilier Crée avec success!');
            }
            else
            {
              session()->flash('messageDelete', 'Cette Piece existe deja');
            }
        // }
        // else
        // {
        //    session()->flash('messageDelete', 'Ce Telephone est deja Attribué');
        // } 
     }
     else
     {
       session()->flash('messageDelete', 'Ce Code est deja Attribué'); 
     }   




       //ON MODIFIE UN OBJECT
      }else{
         
          
        $Affilier = $this->showData($id);
        //Verification de L'unicite du code
        $NbreCode = $this::whereCode($request->Code)->where('id', '!=',$id)->where('Etat', '!=', 2)->count();

        $NbrePiece = $this::wherePieceindentite($request->Piece)->where('id', '!=',$id)->count();

        //$NbreTelephone = Affilier::whereTelephone($request->Telephone)->where('Telephone', '!=', '')->where('id', '!=',$id)->count();
        
    if ($NbreCode == 0) 
    {  
        if ($NbrePiece == 0) 
        {
            // if ($NbreTelephone == 0) 
            // {
            $Affilier->update([
            'Code' => $request->Code,
            'Nom' => $request->Nom,
            'Prenom' => $request->Prenom,
            'Origine' => $request->Origine,
            'DateEntree' => $request->DateEntree,
            'CotisationM' => $request->Cotisation,
            'SoinsAmbilatoire' => $request->SA,
            'PlafondChambre' => $request->HPC,
            'PCNuit' => $request->HPCN,
            'UniteMaternite' => $request->Maternite,
            'ElseUniteMaternite' => $request->MaterniteP,
            'Pharmacie' => $request->Pharmacie,
            'PieceIndentite' => $request->Piece,
            'Telephone' => $request->Telephone,
            'DateNaiss' => $request->DateNaiss,
            'Adresse' => $request->Adresse,
            'Lunette' =>$request->Lunette,
            'dents' =>$request->dents,
            'Hospitalisation'=>$request->Hospitalisation,
            'imagerie'=>$request->Imagerie,
            'reanimation'=>$request->Reanimation,
            'kinesie'=>$request->Kinesitherapie,
            'labo'=>$request->Laboratoire,
            'Medicament' => $request->Medicament
        ]);
        
        $AyantDroit = AyantDroit::whereAffilierAndLien($id,'Lui meme')->first();
        $AyantDroit->update([
            'Affilier' =>$id,
            'Nom' => $request->Nom,
            'Prenom' => $request->Prenom,
            'Lien' => 'Lui meme'
        ]);

            session()->flash('message', 'Affilier Crée avec success!');
            // }
            // else
            // {
            //   session()->flash('messageDelete', 'Num Telephone deja Utilisé');  
            // }
        }
        else
        {
            session()->flash('messageDelete', 'Cette Piece existe');
        }
     }
     else
     {
       session()->flash('messageDelete', 'Ce Code est deja Attribué'); 
     } 
      }
    }

     	
   // //ON SUPPRIMER UN OBJECT
   public function deleteData($id){
       $Affilier = $this->showData($id);
  
        $Affilier->update([
            'Etat' => 1
        ]);

         session()->flash('messageDelete', 'Affilier(s) supprimé(s) avec success');
     }

   public function multidelete($request){
    
   } 

   public function showData($id){
      $Affilier = $this::findOrFail($id);
      return $Affilier;
   }

   //FIND AFFILIE BY ORIGINE
   
   public function AffilierByOrigine($id){
      $Affiliers = $this->whereOrigine($id)->get();
      return $Affiliers;
   }
   
   public function AffilieRedondance(){
       $Nbre = DB::table('affiliers')
               ->select(DB::raw('count(id) as nbre'))
               ->Groupby('affiliers.Code')
               ->Having('nbre', '>', 1)
               ->get();
               return $Nbre;
   }

}
