@extends('layout.base', ['title' => 'Assurance - Nouvelle Facture'])
@section('content')
        <div id="page-wrapper" >
            <div id="page-inner">
                <div class="row">
                    <div class="col-md-12">
        <h2 style="color: blue;font-weight: bold;text-align: center;">Nouvelle Facture</h2>
        </div>
                </div>
                 <!-- /. ROW  -->
                 <hr />
               <div class="row">
                <div class="col-md-12">
                    <!-- Form Elements -->
                    <div class="panel panel-default">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <form role="form" method="POST" action="{{ route('Factures.store')}}">
                                      {{ csrf_field() }}
                                        <div class="form-group" style="display: none;">
                                            <label></label>
                                            <input class="form-control" name="Affilier" value="{{ $Aff }}"/>
                                        </div>
                                         
                                        <div class="form-group">
                                            <label>Béficiaire *</label>
                                            <select class="form-control" name="AyantDroits" id="AyantDroits">
                                              <option></option>
                                               @foreach($AyantDroits as $AyantDroit)
                                                <option value="{{ $AyantDroit->id }}">{{ $AyantDroit->Nom}} {{ $AyantDroit->Prenom}}</option>
                                               @endforeach
                                            </select>
                                            {!! $errors->first('AyantDroits', '<span class="error">:message</span>') !!}
                                        </div>
                                    
                                    @if(session()->get('Profil') == 'User')
                                        <div class="form-group">
                                    <label>Partenaire *</label>
                                            <select class="form-control" name="Partenaire">
                                             <option></option> 
                                            @foreach($Partenaires as $P)
                                               <option value="{{ $P->id}}">{{ $P->Partenaire}}</option>
                                               @endforeach
                                            </select>
                                            {!! $errors->first('Partenaire', '<span class="error">:message</span>') !!}
                                        </div>

                                         <div class="form-group">
                                    <label>Date Transmission *</label>
                                            <input type="date" class="form-control" placeholder="Date Transmission" name="DateTrans" />

                                            {!! $errors->first('DateTrans', '<span class="error">:message</span>') !!}
                                        </div>
                                    @endif    
                                        
                                        <div class="form-group">
                                            <label>Date Traitement *</label>
                                            <input type="date" class="form-control" placeholder="Date Traitement" name="DateT" />

                                            {!! $errors->first('DateT', '<span class="error">:message</span>') !!}
                                        </div>

                                         <label></label><br>
                                        <button type="submit" class="btn btn-primary">Enregistrer</button>
                                        <button type="reset" class="btn btn-default">Annuler</button>

                                      </div>

                                      <div class="col-md-6">
                                        <label>Type de Traitement* : </label> 
                                         
                                        <div class="form-inline">   
                                          @foreach($Services as $Service)
                                            {{ $Service->service}} <input type="radio" value="{{$Service->id}}" class="form-control" name="TraitementT" required="required"/>   
                                          @endforeach    
                                        </div>
                                      </div>  
                                    </form>
                                    <br />                    
    </div>

                            </div>
                        </div>
                    </div>
                     <!-- End Form Elements -->

            <div class="row">
                <div class="col-md-12">
                    <!-- Advanced Tables -->
                    <div class="panel panel-default">
                        <div class="panel-heading">
                           Services Accessibles
                        </div>

                        <div class="panel-body">
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered table-hover" id="dataTables-example">
                                    <thead>
                                        <tr>
                                            <th>Service</th>
                                            <th>Couverture</th>
                                            <th>Partenaire</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                      @foreach($AffilierPartenaire as $AffilierPart)
                                       <tr>
                                            <th>{{$AffilierPart->service}}</th>
                                            @if($AffilierPart->Traitement==1)
                                             <th>Consultation</th>
                                            @elseif($AffilierPart->Traitement==2)
                                            <th>Hospitalisation sans Maternité</th>
                                            @elseif($AffilierPart->Traitement==3)
                                            <th>Hospitalisation avec Maternité</th>
                                             @elseif($AffilierPart->Traitement==4)
                                            <th>Soins Ambulatoire avec Medicament</th>
                                             @elseif($AffilierPart->Traitement==5)
                                            <th>Soins Ambulatoire avec Lunette</th>
                                            @elseif($AffilierPart->Traitement==6)
                                            <th>Dentisterie</th>


                                            @elseif($AffilierPart->Traitement==7)
                                            <th>Laboratoire</th>
                                            @elseif($AffilierPart->Traitement==8)
                                            <th>Kinesitherapie</th>

                                            @elseif($AffilierPart->Traitement==9)
                                            <th>Imagerie Medicale</th>

                                            @elseif($AffilierPart->Traitement==10)
                                            <th>Réanimation</th>
                                            @endif
                                            <th>{{$AffilierPart->Partenaire}}</th>
                                        </tr>
                                      @endforeach  
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!--End Advanced Tables -->
                </div>
            </div>
                </div>
            </div>
    </div>
             <!-- /. PAGE INNER  -->
            </div>
         <!-- /. PAGE WRAPPER  -->
@endsection 

<script type="text/javascript">
   function getBeneficiaire(va){
     var id_affilier= $(va).val();

      $.get('{{ route('getProduiBenfic') }}',
          {id_affilier:id_affilier},
          function(data){
            $('#AyantDroits').html(data);
          });
   }
</script>